(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2632,         81]*)
(*NotebookOutlinePosition[      3475,        108]*)
(*  CellTagsIndexPosition[      3431,        104]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 2.6  .3\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(el[i, j] = 
      Integrate[x^\((i - 1)\)*x\ s^2*s^\((j - 1)\), 
        \ {x, \(-1\), 1}, {s, \(-1\), 1}]\)], "Input"],

Cell[BoxData[
    \(If[Re[j] > \(-2\) && Re[i] > \(-1\), 
      \(-\(\(\((1 + \((\(-1\))\)\^i)\)\ 
              \((\(-1\) + \((\(-1\))\)\^j)\)\)\/\(\((1 + i)\)\ 
              \((2 + j)\)\)\)\), 
      \[Integral]\_\(-1\)\%1
          \((\[Integral]\_\(-1\)\%1\( s\^\(1 + j\)\ x\^i\) \[DifferentialD]s)
            \) \[DifferentialD]x]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(m[i, j] = Integrate[x^\((i - 1)\)*x^\((j - 1)\), {x, \(-1\), 1}]\)], 
  "Input"],

Cell[BoxData[
    \(If[Re[i + j] > 1, \(1 + \((\(-1\))\)\^\(i + j\)\)\/\(\(-1\) + i + j\), 
      \[Integral]\_\(-1\)\%1\( x\^\(\(-2\) + i + j\)\) \[DifferentialD]x]\)], 
  "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{4, Automatic}, {Automatic, -2}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 59, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1801, 54, 139, 3, 43, "Input"],
Cell[1943, 59, 351, 7, 73, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2331, 71, 100, 2, 27, "Input"],
Cell[2434, 75, 182, 3, 47, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

